## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
## 
## CvGreekWorldEventManager
## This class is passed an argsList from CvAppInterface.onEvent
## The argsList can contain anything from mouse location to key info
## The EVENTLIST that are being notified can be found 


from CvPythonExtensions import *
import CvUtil
import CvScreensInterface
import CvDebugTools
import CvWBPopups
import PyHelpers
import Popup as PyPopup
import CvCameraControls
import CvTopCivs
import CvEventManager
import sys
	
gc = CyGlobalContext()
localText = CyTranslator()
PyPlayer = PyHelpers.PyPlayer
PyInfo = PyHelpers.PyInfo

# globals
###################################################
class BananasEventManager(CvEventManager.CvEventManager):
	def __init__(self):
		# initialize base class
		self.parent = CvEventManager.CvEventManager
		self.parent.__init__(self)
		
		
	def onGameStart(self, argsList):
		self.parent.onGameStart(self,argsList)
		if (gc.getGame().getGameTurnYear() == gc.getDefineINT("START_YEAR")):
			for iPlayer in range(gc.getMAX_PLAYERS()):
				player = gc.getPlayer(iPlayer)
				if (player.isAlive() and player.hasTrait(8)):
					gcmap=gc.getMap()
					banaFound = false
					px=player.getStartingPlot().getX()
					py=player.getStartingPlot().getY()
					for x in range(-2,2):
						for y in range (-2,2):
							if not banaFound and not ((x==0 and y==0) or (abs(x)==2 and abs(y)==2)):
								plot = gcmap.plot(px+x,py+y)
								if plot.getTerrainType()==0 and plot.getBonusType(-1)==-1:
									#is grass
									banaFound=true
									plot.setBonusType(9)
									plot.setImprovementType(12)
									plot.setFeatureType(-1,-1)

					if not banaFound:
						#i'm lazy and i give up so just plonk the bananas under the settler
						plot=gcmap.plot(px,py)
						plot.setBonusType(9)
						plot.setImprovementType(12)
						plot.setFeatureType(-1,-1)
					
	
	def onCityDoTurn(self, argsList):
		'City Production'
		pCity,iPlayer = argsList

	 	self.parent.onCityDoTurn(self,argsList)
	 	if pCity.hasTrait(8):
	 		bananas = pCity.getNumBonuses(9)
			pCity.changeExtraHappiness(bananas-pCity.getExtraHappiness())
			
